/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMember;
import proguard.classfile.ProgramMethod;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.StoringInvocationUnit;

public class MemberDescriptorSpecializer
implements MemberVisitor {
    private static final Logger logger = LogManager.getLogger(MemberDescriptorSpecializer.class);
    private final boolean specializeFieldTypes;
    private final boolean specializeMethodParameterTypes;
    private final boolean specializeMethodReturnTypes;
    private final MemberVisitor extraTypeFieldVisitor;
    private final MemberVisitor extraParameterTypeMethodVisitor;
    private final MemberVisitor extraReturnTypeMethodVisitor;

    public MemberDescriptorSpecializer(boolean specializeFieldTypes, boolean specializeMethodParameterTypes, boolean specializeMethodReturnTypes) {
        this(specializeFieldTypes, specializeMethodParameterTypes, specializeMethodReturnTypes, null, null, null);
    }

    public MemberDescriptorSpecializer(boolean specializeFieldTypes, boolean specializeMethodParameterTypes, boolean specializeMethodReturnTypes, MemberVisitor extraTypeFieldVisitor, MemberVisitor extraParameterTypeMethodVisitor, MemberVisitor extraReturnTypeMethodVisitor) {
        this.specializeFieldTypes = specializeFieldTypes;
        this.specializeMethodParameterTypes = specializeMethodParameterTypes;
        this.specializeMethodReturnTypes = specializeMethodReturnTypes;
        this.extraTypeFieldVisitor = extraTypeFieldVisitor;
        this.extraParameterTypeMethodVisitor = extraParameterTypeMethodVisitor;
        this.extraReturnTypeMethodVisitor = extraReturnTypeMethodVisitor;
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        Clazz valueClass;
        Value value;
        String valueType;
        String fieldType = programField.getDescriptor(programClass);
        if (this.specializeFieldTypes && ClassUtil.isInternalClassType(fieldType) && !(valueType = this.valueType(fieldType, value = StoringInvocationUnit.getFieldValue(programField))).equals(fieldType) && (valueClass = value.referenceValue().getReferencedClass()) != null && valueClass.extendsOrImplements(ClassUtil.internalClassNameFromClassType(fieldType)) && (valueClass.getProcessingFlags() & 1) != 0) {
            logger.debug("MemberDescriptorSpecializer [{}.{} {}] -> {}", (Object)programClass.getName(), (Object)programField.getName(programClass), (Object)programField.getDescriptor(programClass), (Object)valueType);
            programField.referencedClass = value.referenceValue().getReferencedClass();
            this.updateDescriptor(programClass, programField, valueType);
            if (this.extraTypeFieldVisitor != null) {
                this.extraTypeFieldVisitor.visitProgramField(programClass, programField);
            }
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        Clazz[] referencedClasses = programMethod.referencedClasses;
        if (referencedClasses != null) {
            Clazz valueClass;
            Value value;
            String valueType;
            String descriptor = programMethod.getDescriptor(programClass);
            boolean isStatic = (programMethod.getAccessFlags() & 8) != 0;
            int parameterIndex = isStatic ? 0 : 1;
            int classIndex = 0;
            InternalTypeEnumeration parameterTypeEnumeration = new InternalTypeEnumeration(descriptor);
            StringBuilder newDescriptorBuffer = new StringBuilder(descriptor.length());
            newDescriptorBuffer.append('(');
            while (parameterTypeEnumeration.hasMoreTypes()) {
                String parameterType = parameterTypeEnumeration.nextType();
                if (this.specializeMethodParameterTypes && ClassUtil.isInternalClassType(parameterType) && !(valueType = this.valueType(parameterType, value = StoringInvocationUnit.getMethodParameterValue(programMethod, parameterIndex))).equals(parameterType) && (valueClass = value.referenceValue().getReferencedClass()) != null && valueClass.extendsOrImplements(ClassUtil.internalClassNameFromClassType(parameterType)) && (valueClass.getProcessingFlags() & 1) != 0) {
                    logger.debug("MemberDescriptorSpecializer [{}.{}{}]: parameter #{}: {} -> {}", (Object)programClass.getName(), (Object)programMethod.getName(programClass), (Object)descriptor, (Object)parameterIndex, (Object)parameterType, (Object)valueType);
                    referencedClasses[classIndex] = valueClass;
                    if (this.extraParameterTypeMethodVisitor != null) {
                        this.extraParameterTypeMethodVisitor.visitProgramMethod(programClass, programMethod);
                    }
                    parameterType = valueType;
                }
                newDescriptorBuffer.append(parameterType);
                if (ClassUtil.isInternalClassType(parameterType)) {
                    ++classIndex;
                }
                ++parameterIndex;
            }
            newDescriptorBuffer.append(')');
            String returnType = parameterTypeEnumeration.returnType();
            if (this.specializeMethodReturnTypes && ClassUtil.isInternalClassType(returnType) && !(valueType = this.valueType(returnType, value = StoringInvocationUnit.getMethodReturnValue(programMethod))).equals(returnType) && (valueClass = value.referenceValue().getReferencedClass()) != null && valueClass.extendsOrImplements(ClassUtil.internalClassNameFromClassType(returnType)) && (valueClass.getProcessingFlags() & 1) != 0) {
                logger.debug("MemberDescriptorSpecializer [{}.{}{}]: return value: {} ->  {}", (Object)programClass.getName(), (Object)programMethod.getName(programClass), (Object)descriptor, (Object)returnType, (Object)valueType);
                referencedClasses[classIndex] = value.referenceValue().getReferencedClass();
                if (this.extraReturnTypeMethodVisitor != null) {
                    this.extraReturnTypeMethodVisitor.visitProgramMethod(programClass, programMethod);
                }
                returnType = valueType;
            }
            newDescriptorBuffer.append(returnType);
            String newDescriptor = newDescriptorBuffer.toString();
            if (!newDescriptor.equals(descriptor)) {
                this.updateDescriptor(programClass, programMethod, newDescriptor);
            }
        }
    }

    private String valueType(String type, Value value) {
        if (value == null || value.computationalType() != 5) {
            return type;
        }
        String valueType = value.referenceValue().getType();
        if (valueType == null) {
            return type;
        }
        return valueType;
    }

    private void updateDescriptor(ProgramClass programClass, ProgramMember programMember, String newDescriptor) {
        String descriptor = programMember.getDescriptor(programClass);
        ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
        programMember.u2descriptorIndex = constantPoolEditor.addUtf8Constant(newDescriptor);
        String name = programMember.getName(programClass);
        String newName = this.newUniqueMemberName(name, descriptor);
        programMember.u2nameIndex = constantPoolEditor.addUtf8Constant(newName);
    }

    private String newUniqueMemberName(String name, String descriptor) {
        return name.equals("<init>") ? "<init>" : name + '$' + Long.toHexString(Math.abs(descriptor.hashCode()));
    }
}

