/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.Map;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.MemberObfuscator;

public class MemberNameCollector
implements MemberVisitor {
    private final boolean allowAggressiveOverloading;
    private final Map descriptorMap;

    public MemberNameCollector(boolean allowAggressiveOverloading, Map descriptorMap) {
        this.allowAggressiveOverloading = allowAggressiveOverloading;
        this.descriptorMap = descriptorMap;
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
        String name = member.getName(clazz);
        if (ClassUtil.isInitializer(name)) {
            return;
        }
        String newName = MemberObfuscator.newMemberName(member);
        if (newName != null) {
            Map nameMap;
            String otherName;
            String descriptor = member.getDescriptor(clazz);
            if (!this.allowAggressiveOverloading || clazz.extendsOrImplements("java/lang/annotation/Annotation")) {
                descriptor = descriptor.substring(0, descriptor.indexOf(41) + 1);
            }
            if ((otherName = (String)(nameMap = MemberObfuscator.retrieveNameMap(this.descriptorMap, descriptor)).get(newName)) == null || MemberObfuscator.hasFixedNewMemberName(member)) {
                nameMap.put(newName, name);
            }
        }
    }
}

