/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.SimpleNameFactory;

public class DictionaryNameFactory
implements NameFactory {
    private static final char COMMENT_CHARACTER = '#';
    private final List<String> names;
    private Set<String> nameSet;
    private final NameFactory nameFactory;
    private int index = 0;

    public DictionaryNameFactory(URL url, NameFactory nameFactory) throws IOException {
        this(url, true, nameFactory);
    }

    public DictionaryNameFactory(URL url, boolean validJavaIdentifiers, NameFactory nameFactory) throws IOException {
        this(new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8)), validJavaIdentifiers, nameFactory);
    }

    public DictionaryNameFactory(File file, NameFactory nameFactory) throws IOException {
        this(file, true, nameFactory);
    }

    public DictionaryNameFactory(File file, boolean validJavaIdentifiers, NameFactory nameFactory) throws IOException {
        this(new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8)), validJavaIdentifiers, nameFactory);
    }

    public DictionaryNameFactory(Reader reader, NameFactory nameFactory) throws IOException {
        this(reader, true, nameFactory);
    }

    public DictionaryNameFactory(Reader reader, boolean validJavaIdentifiers, NameFactory nameFactory) throws IOException {
        this.nameSet = DictionaryNameFactory.readDictionary(reader, validJavaIdentifiers);
        this.nameFactory = nameFactory;
        this.names = new ArrayList<String>(this.nameSet);
    }

    private static Set<String> readDictionary(Reader reader, boolean validJavaIdentifiers) throws IOException {
        try {
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            StringBuilder builder = new StringBuilder();
            while (true) {
                int c;
                if ((c = reader.read()) != -1 && (validJavaIdentifiers ? (builder.length() == 0 ? Character.isJavaIdentifierStart((char)c) : Character.isJavaIdentifierPart((char)c)) : c != 10 && c != 13 && c != 35)) {
                    builder.append((char)c);
                    continue;
                }
                if (builder.length() > 0) {
                    String name = builder.toString();
                    names.add(name);
                    builder.setLength(0);
                }
                if (c == 35) {
                    while ((c = reader.read()) != -1 && c != 10 && c != 13) {
                    }
                }
                if (c != -1) continue;
                LinkedHashSet<String> linkedHashSet = names;
                return linkedHashSet;
            }
        }
        finally {
            reader.close();
        }
    }

    public DictionaryNameFactory(DictionaryNameFactory dictionaryNameFactory, NameFactory nameFactory) {
        this.names = dictionaryNameFactory.names;
        this.nameFactory = nameFactory;
    }

    @Override
    public void reset() {
        this.index = 0;
        this.nameFactory.reset();
    }

    @Override
    public String nextName() {
        String name;
        if (this.index < this.names.size()) {
            name = this.names.get(this.index++);
        } else {
            if (this.nameSet == null) {
                this.nameSet = new HashSet<String>(this.names);
            }
            while (this.nameSet.contains(name = this.nameFactory.nextName())) {
            }
        }
        return name;
    }

    public static void main(String[] args) {
        try {
            DictionaryNameFactory factory = new DictionaryNameFactory(new File(args[0]), (NameFactory)new SimpleNameFactory());
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
            for (int counter = 0; counter < 50; ++counter) {
                out.println("[" + factory.nextName() + "]");
            }
            out.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

