/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util.renderer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleTypeAnnotationsAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.renderer.MemberViewModel;
import proguard.classfile.util.renderer.core.StringListWriter;
import proguard.classfile.visitor.ClassPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class MethodViewModel
extends MemberViewModel {
    private Clazz[] referencedClasses;
    private Map<String, Object> attributes;

    public static MethodViewModel render(Clazz clazz, Method method) {
        MethodViewModel viewModel = new MethodViewModel(clazz, method);
        viewModel.referencedClasses = MethodViewModel.renderReferenceClasses(method);
        viewModel.attributes = MethodViewModel.renderAttribute(clazz, method);
        return viewModel;
    }

    private MethodViewModel(Clazz clazz, Method method) {
        super(clazz, method);
    }

    public String renderPreview() {
        return ClassUtil.externalFullMethodDescription(((Clazz)this.model.key).getName(), ((Member)this.model.value).getAccessFlags(), ((Member)this.model.value).getName((Clazz)this.model.key), ((Member)this.model.value).getDescriptor((Clazz)this.model.key));
    }

    private static Clazz[] renderReferenceClasses(Method method) {
        final ArrayList referencedClasses = new ArrayList();
        method.referencedClassesAccept(new ClassVisitor(){

            @Override
            public void visitAnyClass(Clazz clazz) {
                referencedClasses.add(clazz);
            }
        });
        return referencedClasses.toArray(new Clazz[referencedClasses.size()]);
    }

    private static Map<String, Object> renderAttribute(Clazz clazz, final Method method) {
        final TreeMap<String, Object> attributeList = new TreeMap<String, Object>();
        method.accept(clazz, new MemberVisitor(){

            @Override
            public void visitAnyMember(Clazz clazz, Member member) {
            }

            @Override
            public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
                programMethod.attributesAccept(programClass, new AttributeVisitor(){
                    List<String> exceptionAttributeList = new ArrayList<String>();
                    List<String> signatureAttributeList = new ArrayList<String>();
                    List<String> runtimeInvisibleAnnotationAttributeList = new ArrayList<String>();

                    @Override
                    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
                    }

                    @Override
                    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
                        this.signatureAttributeList.add(this.renderAttributeAsString(clazz, method, signatureAttribute));
                        if (!attributeList.containsKey("signature")) {
                            attributeList.put("signature", this.signatureAttributeList);
                        }
                    }

                    @Override
                    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
                        attributeList.put("code", this.renderAttributeAsList(clazz, method, codeAttribute));
                    }

                    @Override
                    public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
                        this.exceptionAttributeList.add(this.renderAttributeAsString(clazz, method, exceptionsAttribute));
                        if (!attributeList.containsKey("exceptions")) {
                            attributeList.put("exceptions", this.exceptionAttributeList);
                        }
                    }

                    @Override
                    public void visitRuntimeVisibleTypeAnnotationsAttribute(Clazz clazz, RuntimeVisibleTypeAnnotationsAttribute runtimeVisibleTypeAnnotationsAttribute) {
                        this.runtimeInvisibleAnnotationAttributeList.add(this.renderAttributeAsString(clazz, method, runtimeVisibleTypeAnnotationsAttribute));
                        if (!attributeList.containsKey("runtime invisible annotations")) {
                            attributeList.put("runtime invisible annotations", this.runtimeInvisibleAnnotationAttributeList);
                        }
                    }

                    @Override
                    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
                        Object tmp = attributeList.get(annotationsAttribute.getClass().getName());
                        ArrayList attributeContainer = null;
                        attributeContainer = tmp == null ? new ArrayList() : (ArrayList)tmp;
                        this.runtimeInvisibleAnnotationAttributeList.add(this.renderAttributeAsString(clazz, method, annotationsAttribute));
                        if (!attributeList.containsKey(annotationsAttribute.getClass().getName())) {
                            attributeList.put(annotationsAttribute.getClass().getName(), attributeContainer);
                        }
                    }

                    private String renderAttributeAsString(Clazz clazz, Method method, Attribute attribute) {
                        StringWriter stringWriter = new StringWriter();
                        attribute.accept(clazz, method, (AttributeVisitor)new ClassPrinter(new PrintWriter(stringWriter)));
                        stringWriter.flush();
                        return stringWriter.toString();
                    }

                    private List<String> renderAttributeAsList(Clazz clazz, Method method, Attribute attribute) {
                        StringListWriter writer = new StringListWriter(new ArrayList<String>());
                        attribute.accept(clazz, method, (AttributeVisitor)new ClassPrinter(new PrintWriter(writer)));
                        return writer.getOutput();
                    }
                });
            }
        });
        return attributeList;
    }
}

