/*
 * Decompiled with CFR 0.152.
 */
package proguard.ant;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import proguard.ClassSpecification;
import proguard.MemberSpecification;
import proguard.ant.MemberSpecificationElement;
import proguard.classfile.util.ClassUtil;

public class ClassSpecificationElement
extends DataType {
    private static final String ANY_CLASS_KEYWORD = "*";
    private String access;
    private String annotation;
    private String type;
    private String name;
    private String extendsAnnotation;
    private String extends_;
    private List fieldSpecifications = new ArrayList();
    private List methodSpecifications = new ArrayList();

    public void appendTo(List classSpecifications) {
        ClassSpecificationElement classSpecificationElement = this.isReference() ? (ClassSpecificationElement)this.getCheckedRef(this.getClass(), this.getClass().getName()) : this;
        ClassSpecification classSpecification = this.createClassSpecification(classSpecificationElement);
        classSpecifications.add(classSpecification);
    }

    protected ClassSpecification createClassSpecification(ClassSpecificationElement classSpecificationElement) {
        int index;
        String access = classSpecificationElement.access;
        String annotation = classSpecificationElement.annotation;
        String type = classSpecificationElement.type;
        String name = classSpecificationElement.name;
        String extendsAnnotation = classSpecificationElement.extendsAnnotation;
        String extends_ = classSpecificationElement.extends_;
        if (name != null && name.equals(ANY_CLASS_KEYWORD)) {
            name = null;
        }
        ClassSpecification classSpecification = new ClassSpecification(null, this.requiredAccessFlags(true, access, type), this.requiredAccessFlags(false, access, type), annotation != null ? ClassUtil.internalType(annotation) : null, name != null ? ClassUtil.internalClassName(name) : null, extendsAnnotation != null ? ClassUtil.internalType(extendsAnnotation) : null, extends_ != null ? ClassUtil.internalClassName(extends_) : null);
        for (index = 0; index < this.fieldSpecifications.size(); ++index) {
            classSpecification.addField((MemberSpecification)this.fieldSpecifications.get(index));
        }
        for (index = 0; index < this.methodSpecifications.size(); ++index) {
            classSpecification.addMethod((MemberSpecification)this.methodSpecifications.get(index));
        }
        return classSpecification;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExtendsannotation(String extendsAnnotation) {
        this.extendsAnnotation = extendsAnnotation;
    }

    public void setExtends(String extends_) {
        this.extends_ = extends_;
    }

    public void setImplements(String implements_) {
        this.extends_ = implements_;
    }

    public void addConfiguredField(MemberSpecificationElement memberSpecificationElement) {
        if (this.fieldSpecifications == null) {
            this.fieldSpecifications = new ArrayList();
        }
        memberSpecificationElement.appendTo(this.fieldSpecifications, false, false);
    }

    public void addConfiguredMethod(MemberSpecificationElement memberSpecificationElement) {
        if (this.methodSpecifications == null) {
            this.methodSpecifications = new ArrayList();
        }
        memberSpecificationElement.appendTo(this.methodSpecifications, true, false);
    }

    public void addConfiguredConstructor(MemberSpecificationElement memberSpecificationElement) {
        if (this.methodSpecifications == null) {
            this.methodSpecifications = new ArrayList();
        }
        memberSpecificationElement.appendTo(this.methodSpecifications, true, true);
    }

    private int requiredAccessFlags(boolean set, String access, String type) throws BuildException {
        int accessFlags = 0;
        if (access != null) {
            StringTokenizer tokenizer = new StringTokenizer(access, " ,");
            while (tokenizer.hasMoreTokens()) {
                int accessFlag;
                String strippedToken;
                String token = tokenizer.nextToken();
                if (!(token.startsWith("!") ^ set)) continue;
                String string = strippedToken = token.startsWith("!") ? token.substring(1) : token;
                int n = strippedToken.equals("public") ? 1 : (strippedToken.equals("final") ? 16 : (strippedToken.equals("abstract") ? 1024 : (strippedToken.equals("synthetic") ? 4096 : (accessFlag = strippedToken.equals("@") ? 8192 : 0))));
                if (accessFlag == 0) {
                    throw new BuildException("Incorrect class access modifier [" + strippedToken + "]");
                }
                accessFlags |= accessFlag;
            }
        }
        if (type != null && type.startsWith("!") ^ set) {
            int accessFlag;
            int n = type.equals("class") ? 0 : (type.equals("interface") || type.equals("!interface") ? 512 : (accessFlag = type.equals("enum") || type.equals("!enum") ? 16384 : -1));
            if (accessFlag == -1) {
                throw new BuildException("Incorrect class type [" + type + "]");
            }
            accessFlags |= accessFlag;
        }
        return accessFlags;
    }
}

