/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.File;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.DataEntryReaderFactory;
import proguard.ProGuard;
import proguard.classfile.ClassPool;
import proguard.io.CascadingDataEntryWriter;
import proguard.io.ClassDataEntryWriter;
import proguard.io.DataEntryNameFilter;
import proguard.io.DataEntryParentFilter;
import proguard.io.DataEntryWriter;
import proguard.io.DirectoryWriter;
import proguard.io.FilteredDataEntryWriter;
import proguard.io.FixedFileWriter;
import proguard.io.NameFilteredDataEntryWriter;
import proguard.io.NonClosingDataEntryWriter;
import proguard.io.ParentDataEntryWriter;
import proguard.io.PrefixAddingDataEntryWriter;
import proguard.io.RenamedDataEntryWriter;
import proguard.io.SignedJarWriter;
import proguard.io.ZipWriter;
import proguard.resources.file.ResourceFilePool;
import proguard.util.ConstantStringFunction;
import proguard.util.ExtensionMatcher;
import proguard.util.FileNameParser;
import proguard.util.ListFunctionParser;
import proguard.util.ListParser;
import proguard.util.SingleFunctionParser;
import proguard.util.StringFunction;
import proguard.util.StringMatcher;
import proguard.util.WildcardManager;

public class DataEntryWriterFactory {
    private static final boolean ENABLE_ZIP64_SUPPORT = System.getProperty("enable.zip64.support") != null;
    private static final String CLASS_FILE_PATTERN = "**.class";
    private static final String CLASS_FILE_PREFIX = "classes/";
    private static final byte[] JMOD_HEADER = new byte[]{74, 77, 1, 0};
    private static final int PAGE_ALIGNMENT = 4096;
    private final String[][] JMOD_PREFIXES = new String[][]{{"**.class", "classes/"}};
    private final String[][] WAR_PREFIXES = new String[][]{{"**.class", "classes/"}};
    private final ClassPool programClassPool;
    private final ResourceFilePool resourceFilePool;
    private final int modificationTime;
    private final StringMatcher uncompressedFilter;
    private final int uncompressedAlignment;
    private final boolean pageAlignNativeLibs;
    private final boolean mergeAarJars;
    private final KeyStore.PrivateKeyEntry[] privateKeyEntries;
    private final Map<File, DataEntryWriter> jarWriterCache = new HashMap<File, DataEntryWriter>();
    private final Function<DataEntryWriter, DataEntryWriter> alternativeClassDataEntryWriterProvider;

    public DataEntryWriterFactory(ClassPool programClassPool, ResourceFilePool resourceFilePool, int modificationTime, StringMatcher uncompressedFilter, int uncompressedAlignment, boolean pageAlignNativeLibs, boolean mergeAarJars, KeyStore.PrivateKeyEntry[] privateKeyEntries) {
        this(programClassPool, resourceFilePool, modificationTime, uncompressedFilter, uncompressedAlignment, pageAlignNativeLibs, mergeAarJars, privateKeyEntries, null);
    }

    public DataEntryWriterFactory(ClassPool programClassPool, ResourceFilePool resourceFilePool, int modificationTime, StringMatcher uncompressedFilter, int uncompressedAlignment, boolean pageAlignNativeLibs, boolean mergeAarJars, KeyStore.PrivateKeyEntry[] privateKeyEntries, Function<DataEntryWriter, DataEntryWriter> alternativeClassDataEntryWriterProvider) {
        this.programClassPool = programClassPool;
        this.resourceFilePool = resourceFilePool;
        this.modificationTime = modificationTime;
        this.uncompressedFilter = uncompressedFilter;
        this.uncompressedAlignment = uncompressedAlignment;
        this.pageAlignNativeLibs = pageAlignNativeLibs;
        this.mergeAarJars = mergeAarJars;
        this.privateKeyEntries = privateKeyEntries;
        this.alternativeClassDataEntryWriterProvider = alternativeClassDataEntryWriterProvider;
    }

    public DataEntryWriter createDataEntryWriter(ClassPath classPath, int fromIndex, int toIndex, DataEntryWriter extraDataEntryWriter) {
        DataEntryWriter writer = null;
        for (int index = toIndex - 1; index >= fromIndex; --index) {
            ClassPathEntry entry = classPath.get(index);
            boolean addCheckingJarWriter = !this.outputFileOccurs(entry, classPath, 0, index);
            boolean closeCachedJarWriter = !this.outputFileOccurs(entry, classPath, index + 1, classPath.size());
            writer = this.createClassPathEntryWriter(entry, writer, extraDataEntryWriter, addCheckingJarWriter, closeCachedJarWriter);
        }
        return writer;
    }

    private boolean outputFileOccurs(ClassPathEntry entry, ClassPath classPath, int startIndex, int endIndex) {
        File file = entry.getFile();
        for (int index = startIndex; index < endIndex; ++index) {
            ClassPathEntry classPathEntry = classPath.get(index);
            if (!classPathEntry.isOutput() || !classPathEntry.getFile().equals(file)) continue;
            return true;
        }
        return false;
    }

    private DataEntryWriter createClassPathEntryWriter(ClassPathEntry classPathEntry, DataEntryWriter alternativeWriter, DataEntryWriter extraDataEntryWriter, boolean addCheckingJarWriter, boolean closeCachedJarWriter) {
        DataEntryWriter writer;
        File file = classPathEntry.getFile();
        boolean isDex = classPathEntry.isDex();
        boolean isApk = classPathEntry.isApk();
        boolean isAab = classPathEntry.isAab();
        boolean isJar = classPathEntry.isJar();
        boolean isAar = classPathEntry.isAar();
        boolean isWar = classPathEntry.isWar();
        boolean isEar = classPathEntry.isEar();
        boolean isJmod = classPathEntry.isJmod();
        boolean isZip = classPathEntry.isZip();
        boolean isFile = isDex || isApk || isAab || isJar || isAar || isWar || isEar || isJmod || isZip;
        List<String> filter = DataEntryReaderFactory.getFilterExcludingVersionedClasses(classPathEntry);
        List<String> apkFilter = classPathEntry.getApkFilter();
        List<String> aabFilter = classPathEntry.getAabFilter();
        List<String> jarFilter = classPathEntry.getJarFilter();
        List<String> aarFilter = classPathEntry.getAarFilter();
        List<String> warFilter = classPathEntry.getWarFilter();
        List<String> earFilter = classPathEntry.getEarFilter();
        List<String> jmodFilter = classPathEntry.getJmodFilter();
        List<String> zipFilter = classPathEntry.getZipFilter();
        DataEntryWriter dataEntryWriter = writer = isFile ? new FixedFileWriter(file) : new DirectoryWriter(file);
        if (isDex) {
            writer = new FilteredDataEntryWriter(new DataEntryNameFilter(new ExtensionMatcher(".dex")), writer);
        } else {
            boolean flattenApks = false;
            boolean flattenAabs = flattenApks || isApk;
            boolean flattenJars = flattenAabs || isAab;
            boolean flattenAars = flattenJars || isJar;
            boolean flattenWars = flattenAars || isAar;
            boolean flattenEars = flattenWars || isWar;
            boolean flattenJmods = flattenEars || isEar;
            boolean flattenZips = flattenJmods || isJmod;
            writer = this.wrapInJarWriter(file, writer, extraDataEntryWriter, closeCachedJarWriter, flattenZips, isZip, false, ".zip", zipFilter, null, false, null);
            writer = this.wrapInJarWriter(file, writer, extraDataEntryWriter, closeCachedJarWriter, flattenJmods, isJmod, false, ".jmod", jmodFilter, JMOD_HEADER, false, this.JMOD_PREFIXES);
            writer = this.wrapInJarWriter(file, writer, extraDataEntryWriter, closeCachedJarWriter, flattenEars, isEar, false, ".ear", earFilter, null, false, null);
            writer = this.wrapInJarWriter(file, writer, extraDataEntryWriter, closeCachedJarWriter, flattenWars, isWar, false, ".war", warFilter, null, false, this.WAR_PREFIXES);
            writer = this.wrapInJarWriter(file, writer, extraDataEntryWriter, closeCachedJarWriter, flattenAars, isAar, false, ".aar", aarFilter, null, false, null);
            if (isAar) {
                writer = this.mergeAarJars ? new FilteredDataEntryWriter(new DataEntryNameFilter(new ExtensionMatcher(".jar")), new RenamedDataEntryWriter(new ConstantStringFunction("classes.jar"), writer), writer) : new FilteredDataEntryWriter(new DataEntryNameFilter(new ExtensionMatcher(".jar")), new RenamedDataEntryWriter(string -> {
                    String fileName = string.substring(string.lastIndexOf(47) + 1);
                    if (fileName.equals("classes.jar")) {
                        return fileName;
                    }
                    return "libs/" + fileName;
                }, writer), writer);
            }
            writer = this.wrapInJarWriter(file, writer, extraDataEntryWriter, closeCachedJarWriter, flattenJars, isJar, false, ".jar", jarFilter, null, false, null);
            writer = isAab ? this.wrapInJarWriter(file, writer, extraDataEntryWriter, closeCachedJarWriter, flattenAabs, isAab, true, ".aab", aabFilter, null, false, null) : this.wrapInJarWriter(file, writer, extraDataEntryWriter, closeCachedJarWriter, flattenApks, isApk, false, ".apk", apkFilter, null, this.pageAlignNativeLibs, null);
            DataEntryWriter classWriter = new ClassDataEntryWriter(this.programClassPool, new NonClosingDataEntryWriter(writer));
            if (filter != null) {
                WildcardManager wildcardManager = new WildcardManager();
                StringFunction fileNameFunction = new ListFunctionParser(new SingleFunctionParser(new FileNameParser(wildcardManager), wildcardManager)).parse(filter);
                classWriter = new RenamedDataEntryWriter(fileNameFunction, classWriter);
                writer = new RenamedDataEntryWriter(fileNameFunction, writer);
            }
            writer = new NameFilteredDataEntryWriter(new ExtensionMatcher(".class"), this.alternativeClassDataEntryWriterProvider != null ? this.alternativeClassDataEntryWriterProvider.apply(writer) : classWriter, writer);
        }
        return alternativeWriter != null ? new CascadingDataEntryWriter(writer, alternativeWriter) : writer;
    }

    private DataEntryWriter wrapInJarWriter(File file, DataEntryWriter writer, DataEntryWriter extraDataEntryWriter, boolean closeCachedJarWriter, boolean flatten, boolean isJar, boolean isAab, String jarFilterExtension, List<String> jarFilter, byte[] jarHeader, boolean pageAlignNativeLibs, String[][] prefixes) {
        DataEntryWriter zipWriter;
        StringMatcher pageAlignmentFilter;
        StringMatcher stringMatcher = pageAlignmentFilter = pageAlignNativeLibs ? new FileNameParser().parse("lib/*/*.so") : null;
        if (flatten) {
            zipWriter = new ParentDataEntryWriter(writer);
        } else if (!isJar || (zipWriter = this.jarWriterCache.get(file)) == null) {
            zipWriter = this.wrapInSignedJarWriter(writer, extraDataEntryWriter, isAab, jarHeader, pageAlignmentFilter);
            if (prefixes != null) {
                DataEntryWriter prefixlessJarWriter = zipWriter;
                for (int index = prefixes.length - 1; index >= 0; --index) {
                    String prefixFileNameFilter = prefixes[index][0];
                    String prefix = prefixes[index][1];
                    zipWriter = new FilteredDataEntryWriter(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(prefixFileNameFilter)), new PrefixAddingDataEntryWriter(prefix, prefixlessJarWriter), zipWriter);
                }
            }
            if (isJar) {
                this.jarWriterCache.put(file, zipWriter);
            }
        }
        if (isJar && !closeCachedJarWriter) {
            zipWriter = new NonClosingDataEntryWriter(zipWriter);
        }
        return new FilteredDataEntryWriter(new DataEntryParentFilter(new DataEntryNameFilter(new ExtensionMatcher(jarFilterExtension))), jarFilter != null ? new FilteredDataEntryWriter(new DataEntryParentFilter(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(jarFilter))), zipWriter) : zipWriter, isJar ? zipWriter : writer);
    }

    private DataEntryWriter wrapInSignedJarWriter(DataEntryWriter writer, DataEntryWriter extraDataEntryWriter, boolean isAab, byte[] jarHeader, StringMatcher pageAlignmentFilter) {
        DataEntryWriter zipWriter = new ZipWriter(this.uncompressedFilter, this.uncompressedAlignment, ENABLE_ZIP64_SUPPORT, pageAlignmentFilter, 4096, this.modificationTime, jarHeader, writer);
        if (this.privateKeyEntries != null) {
            zipWriter = new SignedJarWriter(this.privateKeyEntries[0], new String[]{"SHA-256"}, ProGuard.VERSION, null, zipWriter);
        }
        return zipWriter;
    }
}

