/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.vartacraft.launcher;

import fr.theshark34.openlauncherlib.minecraft.AuthInfos;
import fr.theshark34.openlauncherlib.minecraft.GameInfos;
import fr.theshark34.openlauncherlib.minecraft.GameTweak;
import fr.theshark34.openlauncherlib.minecraft.GameType;
import fr.theshark34.openlauncherlib.minecraft.GameVersion;
import fr.theshark34.openlauncherlib.util.CrashReporter;
import fr.theshark34.openlauncherlib.util.Saver;
import fr.theshark34.supdate.SUpdate;
import fr.theshark34.supdate.application.integrated.FileDeleter;
import fr.theshark34.swinger.Swinger;
import fr.vartax.vartacraft.ada.AntiCheat;
import fr.vartax.vartacraft.launcher.AllowedMemory;
import fr.vartax.vartacraft.launcher.CrashFrame;
import fr.vartax.vartacraft.launcher.DiscordManager;
import fr.vartax.vartacraft.launcher.LauncherFrame;
import fr.vartax.vartacraft.launcher.ZipUtils;
import fr.vartax.vartacraft.launcher.utils.TrayManager;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Scanner;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class VartacraftLauncher {
    public static final GameVersion ED_VERSION = new GameVersion("1.12.2", GameType.V1_8_HIGHER);
    public static final GameInfos ED_INFOS = new GameInfos("Vartacraft", ED_VERSION, new GameTweak[]{GameTweak.FORGE});
    public static final File ED_DIR = ED_INFOS.getGameDir();
    public static final Saver ED_SAVER = new Saver(new File(ED_DIR, "launcher.properties"));
    public static final CrashReporter ED_CRASH = new CrashReporter(ED_INFOS.getServerName(), new File(ED_DIR, "crashs"));
    public static final String ED_URL = "http://vartacraft.ouiweb.eu/update/vartacraft.zip";
    public static final SUpdate ED_UPDATER = new SUpdate("http://vartacraft.ouiweb.eu/update/vartacraft.zip", ED_DIR);
    public static Font ED_FONT_BOLD;
    public static Font ED_FONT_LOW;
    private static AuthInfos authInfos;
    private static Thread updateThread;
    private static Process gameProcess;
    private static ServerSocket lockSocket;

    public static void main(String[] args) {
        if (!VartacraftLauncher.isUniqueInstance()) {
            JOptionPane.showMessageDialog(null, "Vartacraft est d\u00e9j\u00e0 lanc\u00e9 !", "Instance d\u00e9j\u00e0 active", 2);
            System.exit(0);
            return;
        }
        Swinger.setSystemLookNFeel();
        Swinger.setResourcePath("/");
        if (!ED_DIR.exists()) {
            ED_DIR.mkdirs();
        }
        ED_UPDATER.addApplication(new FileDeleter());
        try {
            ED_FONT_BOLD = Font.createFont(0, VartacraftLauncher.getResourceAsStream("edosz.ttf"));
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(ED_FONT_BOLD);
            ED_FONT_LOW = Font.createFont(0, VartacraftLauncher.getResourceAsStream("abeezee.ttf"));
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(ED_FONT_LOW);
        }
        catch (Exception e) {
            ED_FONT_BOLD = new Font("Arial", 1, 18);
            ED_FONT_LOW = new Font("Arial", 0, 14);
        }
        DiscordManager.init();
        TrayManager.createTray();
        new LauncherFrame().setVisible(true);
    }

    private static boolean isUniqueInstance() {
        try {
            lockSocket = new ServerSocket(65432);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void auth(String user) {
        authInfos = new AuthInfos(user, "token", "uuid");
        ED_SAVER.set("username", user);
    }

    public static void update() throws Exception {
        File versionDir = new File(ED_DIR, "version");
        File minecraftJar = new File(versionDir, "minecraft.jar");
        File modsDir = new File(ED_DIR, "mods");
        if (minecraftJar.exists() && modsDir.exists() && modsDir.listFiles().length > 0) {
            LauncherFrame.getInstance().getPanel().setInfoText("V\u00e9rification termin\u00e9e.");
            return;
        }
        LauncherFrame.getInstance().getPanel().setAnimatedText("T\u00e9l\u00e9chargement");
        File zipFile = new File(ED_DIR, "vartacraft.zip");
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream in = new URL(ED_URL).openStream();){
            Files.copy(in, zipFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ZipUtils.unzip(zipFile, ED_DIR);
        zipFile.delete();
        LauncherFrame.getInstance().getPanel().setInfoText("Pr\u00eat \u00e0 jouer !");
    }

    public static void launch() {
        try {
            File gameDir = ED_DIR;
            File modsDir = new File(gameDir, "mods");
            LauncherFrame.getInstance().getPanel().setInfoText("V\u00e9rification Anti-Cheat...");
            if (!AntiCheat.checkMods(modsDir)) {
                JOptionPane.showMessageDialog(null, "Fichiers interdits d\u00e9tect\u00e9s et supprim\u00e9s.\nMerci de relancer le jeu.", "Anti-Cheat", 0);
                return;
            }
            DiscordManager.updatePresence("En jeu sur Vartacraft", "Joueur : " + authInfos.getUsername());
            File versionDir = new File(gameDir, "version");
            File nativesDir = new File(versionDir, "natives");
            File minecraftJar = new File(versionDir, "minecraft.jar");
            File librariesDir = new File(gameDir, "libraries");
            String ramName = ED_SAVER.get("allowed-memory", "XMX2G");
            AllowedMemory ram = AllowedMemory.valueOf(ramName);
            StringBuilder cp = new StringBuilder();
            if (minecraftJar.exists()) {
                cp.append(minecraftJar.getAbsolutePath()).append(File.pathSeparator);
            }
            if (librariesDir.exists()) {
                Files.walk(librariesDir.toPath(), new FileVisitOption[0]).filter(p -> p.toString().endsWith(".jar")).forEach(p -> {
                    StringBuilder stringBuilder2 = cp.append(p.toAbsolutePath().toString()).append(File.pathSeparator);
                });
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add("java");
            for (String arg : ram.getVmArgs()) {
                command.add(arg);
            }
            command.add("-XX:+UseG1GC");
            command.add("-XX:+UnlockExperimentalVMOptions");
            command.add("-XX:G1NewSizePercent=20");
            command.add("-XX:G1ReservePercent=20");
            command.add("-XX:MaxGCPauseMillis=50");
            command.add("-XX:G1HeapRegionSize=32M");
            command.add("-Dsun.rmi.dgc.server.gcInterval=2147483646");
            command.add("-Djava.library.path=" + nativesDir.getAbsolutePath());
            command.add("-cp");
            command.add(cp.toString());
            command.add("net.minecraft.launchwrapper.Launch");
            command.add("--username");
            command.add(authInfos.getUsername());
            command.add("--version");
            command.add("1.12.2-forge");
            command.add("--gameDir");
            command.add(gameDir.getAbsolutePath());
            command.add("--assetsDir");
            command.add(new File(gameDir, "assets").getAbsolutePath());
            command.add("--assetIndex");
            command.add("1.12");
            command.add("--uuid");
            command.add(authInfos.getUuid());
            command.add("--accessToken");
            command.add(authInfos.getAccessToken());
            command.add("--userProperties");
            command.add("{}");
            command.add("--userType");
            command.add("mojang");
            command.add("--tweakClass");
            command.add("net.minecraftforge.fml.common.launcher.FMLTweaker");
            command.add("--versionType");
            command.add("Forge");
            System.out.println("[LAUNCHER] Commande de lancement :");
            System.out.println(String.join((CharSequence)" ", command));
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.directory(gameDir);
            pb.redirectErrorStream(true);
            gameProcess = pb.start();
            LauncherFrame.getInstance().setVisible(false);
            TrayManager.displayMessage("Vartacraft", "Jeu lanc\u00e9 !");
            StringBuilder wholeLog = new StringBuilder();
            new Thread(() -> {
                Throwable throwable = null;
                Object var2_3 = null;
                try (Scanner s = new Scanner(gameProcess.getInputStream());){
                    while (s.hasNextLine()) {
                        String line = s.nextLine();
                        System.out.println("[GAME] " + line);
                        wholeLog.append(line).append("\n");
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }).start();
            int exitCode = gameProcess.waitFor();
            SwingUtilities.invokeLater(() -> {
                LauncherFrame.getInstance().getPanel().setInfoText("Pr\u00eat \u00e0 jouer !");
                DiscordManager.updatePresence("Sur le Launcher", "Pr\u00eat \u00e0 jouer");
                LauncherFrame.getInstance().setVisible(true);
                if (exitCode != 0) {
                    new CrashFrame(wholeLog.toString()).setVisible(true);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Erreur lors du lancement : " + e.getMessage(), "Erreur", 0);
        }
    }

    public static void shutdown() {
        int confirm = JOptionPane.showConfirmDialog(null, "Voulez-vous vraiment quitter ? Cela fermera aussi le jeu s'il est lanc\u00e9.", "Quitter Vartacraft", 0);
        if (confirm == 0) {
            DiscordManager.stop();
            if (gameProcess != null && gameProcess.isAlive()) {
                gameProcess.destroyForcibly();
            }
            try {
                if (lockSocket != null) {
                    lockSocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    private static InputStream getResourceAsStream(String name) {
        return VartacraftLauncher.class.getResourceAsStream("/" + name);
    }
}

