/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.vartacraft.launcher;

import fr.theshark34.swinger.Swinger;
import fr.theshark34.swinger.colored.SColoredBar;
import fr.theshark34.swinger.event.SwingerEvent;
import fr.theshark34.swinger.event.SwingerEventListener;
import fr.theshark34.swinger.textured.STexturedButton;
import fr.vartax.vartacraft.launcher.DiscordManager;
import fr.vartax.vartacraft.launcher.LauncherFrame;
import fr.vartax.vartacraft.launcher.OptionFrame;
import fr.vartax.vartacraft.launcher.VartacraftLauncher;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class LauncherPanel
extends JPanel
implements SwingerEventListener {
    private Image background = Swinger.getResource("background.png");
    private Image fields = Swinger.getResource("fields.png");
    private JTextField usernameField = new JTextField();
    private STexturedButton playButton = new STexturedButton(Swinger.getResource("play.png"), Swinger.getResource("play-hover.png"));
    private STexturedButton quitButton = new STexturedButton(Swinger.getResource("close.png"));
    private STexturedButton hideButton = new STexturedButton(Swinger.getResource("hide.png"));
    private STexturedButton settingsButton = new STexturedButton(Swinger.getResource("settings.png"));
    private SColoredBar progressBar = new SColoredBar(Swinger.getTransparentWhite(100), Color.WHITE);
    private JLabel infoLabel = new JLabel("Bienvenue sur Vartacraft", 0);
    private Timer animationTimer;
    private int dotCount = 0;
    private String baseText = "";

    public LauncherPanel() {
        this.setLayout(null);
        this.setSize(990, 610);
        String savedUsername = VartacraftLauncher.ED_SAVER.get("username");
        if (savedUsername != null && !savedUsername.isEmpty()) {
            this.usernameField.setText(savedUsername);
        }
        this.usernameField.setForeground(Color.BLACK);
        this.usernameField.setFont(VartacraftLauncher.ED_FONT_LOW.deriveFont(22.0f));
        this.usernameField.setCaretColor(Color.BLACK);
        this.usernameField.setOpaque(false);
        this.usernameField.setBorder(null);
        this.usernameField.setHorizontalAlignment(0);
        this.usernameField.setBounds(320, 230, 220, 38);
        this.add(this.usernameField);
        this.playButton.setBounds(330, 280);
        this.playButton.addEventListener(this);
        this.add(this.playButton);
        this.quitButton.setBounds(810, 14);
        this.quitButton.addEventListener(this);
        this.add(this.quitButton);
        this.hideButton.setBounds(770, 14);
        this.hideButton.addEventListener(this);
        this.add(this.hideButton);
        this.settingsButton.setBounds(730, 14);
        this.settingsButton.addEventListener(this);
        this.add(this.settingsButton);
        this.progressBar.setBounds(50, 540, 760, 15);
        this.progressBar.setVisible(false);
        this.add(this.progressBar);
        this.infoLabel.setForeground(Color.WHITE);
        this.infoLabel.setFont(VartacraftLauncher.ED_FONT_BOLD.deriveFont(20.0f));
        this.infoLabel.setBounds(0, 500, 880, 40);
        this.add(this.infoLabel);
        this.animationTimer = new Timer(500, e -> {
            ++this.dotCount;
            if (this.dotCount > 3) {
                this.dotCount = 0;
            }
            StringBuilder dots = new StringBuilder();
            int i = 0;
            while (i < this.dotCount) {
                dots.append(".");
                ++i;
            }
            this.infoLabel.setText(String.valueOf(this.baseText) + dots.toString());
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.background, 0, 0, this.getWidth(), this.getHeight(), this);
        g.drawImage(this.fields, 320, 210, this);
    }

    public void setAnimatedText(String text) {
        this.baseText = text;
        if (!this.animationTimer.isRunning()) {
            this.animationTimer.start();
        }
    }

    public void stopAnimation(String finalMessage) {
        this.animationTimer.stop();
        this.infoLabel.setText(finalMessage);
    }

    public SColoredBar getProgressBar() {
        return this.progressBar;
    }

    public void setInfoText(String infoText) {
        this.baseText = infoText;
        this.infoLabel.setText(infoText);
    }

    @Override
    public void onEvent(SwingerEvent event) {
        if (event.getType() == 0) {
            if (event.getSource() == this.quitButton) {
                VartacraftLauncher.shutdown();
            } else if (event.getSource() == this.hideButton) {
                LauncherFrame.getInstance().setState(1);
            } else if (event.getSource() == this.settingsButton) {
                OptionFrame.getInstance().setVisible(true);
            } else if (event.getSource() == this.playButton) {
                this.lancerJeu();
            }
        }
    }

    private void lancerJeu() {
        final String pseudo = this.usernameField.getText().trim();
        if (pseudo.isEmpty() || pseudo.length() < 3) {
            this.setInfoText("Pseudo invalide !");
            return;
        }
        new Thread("Launch procedure"){

            @Override
            public void run() {
                VartacraftLauncher.auth(pseudo);
                LauncherPanel.this.usernameField.setEnabled(false);
                LauncherPanel.this.playButton.setEnabled(false);
                LauncherPanel.this.progressBar.setVisible(true);
                try {
                    LauncherPanel.this.setAnimatedText("V\u00e9rification des fichiers");
                    VartacraftLauncher.update();
                    LauncherPanel.this.setAnimatedText("Lancement de Minecraft");
                    DiscordManager.updatePresence("En jeu sur Vartacraft", "Joueur : " + pseudo);
                    VartacraftLauncher.launch();
                }
                catch (Exception ex) {
                    DiscordManager.updatePresence("Sur le Launcher", "Pr\u00eat \u00e0 jouer");
                    LauncherPanel.this.stopAnimation("Erreur critique !");
                    ex.printStackTrace();
                    SwingUtilities.invokeLater(() -> {
                        LauncherPanel.this.usernameField.setEnabled(true);
                        LauncherPanel.this.playButton.setEnabled(true);
                    });
                }
            }
        }.start();
    }
}

