/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.swinger.colored;

import fr.theshark34.swinger.Swinger;
import fr.theshark34.swinger.abstractcomponents.AbstractProgressBar;
import java.awt.Color;
import java.awt.Graphics;

public class SColoredBar
extends AbstractProgressBar {
    private Color background;
    private Color foreground;

    public SColoredBar(Color background) {
        this(background, null);
    }

    public SColoredBar(Color background, Color foreground) {
        if (background == null) {
            throw new IllegalArgumentException("background == null");
        }
        this.background = background;
        this.foreground = foreground == null ? background.brighter() : foreground;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Swinger.fillFullsizedRect(g, this, this.background);
        int fgSize = Swinger.crossMult(this.getValue(), this.getMaximum(), this.isVertical() ? this.getHeight() : this.getWidth());
        if (fgSize > 0) {
            g.setColor(this.foreground);
            g.fillRect(0, 0, this.isVertical() ? this.getWidth() : fgSize, this.isVertical() ? fgSize : this.getHeight());
        }
        if (this.isStringPainted() && this.getString() != null) {
            Swinger.activateAntialias(g);
            if (this.getStringColor() != null) {
                g.setColor(this.getStringColor());
            }
            Swinger.drawCenteredString(g, this.getString(), this.getBounds());
        }
    }

    @Override
    public void setBackground(Color background) {
        if (background == null) {
            throw new IllegalArgumentException("background == null");
        }
        this.background = background;
        this.repaint();
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public void setForeground(Color foreground) {
        if (foreground == null) {
            throw new IllegalArgumentException("foreground == null");
        }
        this.foreground = foreground;
        this.repaint();
    }

    @Override
    public Color getForeground() {
        return this.foreground;
    }
}

