/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.minecraft;

import fr.theshark34.openlauncherlib.minecraft.GameTweak;
import fr.theshark34.openlauncherlib.minecraft.GameType;
import fr.theshark34.openlauncherlib.minecraft.GameVersion;
import fr.theshark34.openlauncherlib.minecraft.util.GameDirGenerator;
import java.io.File;

public class GameInfos {
    private String serverName;
    private File gameDir;
    private GameTweak[] tweaks;
    private GameVersion gameVersion;

    public GameInfos(String serverName, GameVersion gameVersion, GameTweak[] tweaks) {
        this(serverName, GameDirGenerator.createGameDir(serverName), gameVersion, tweaks);
    }

    public GameInfos(String serverName, File gameDir, GameVersion gameVersion, GameTweak[] tweaks) {
        this.serverName = serverName;
        this.gameDir = gameDir;
        this.gameVersion = gameVersion;
        this.tweaks = tweaks;
        if (tweaks != null) {
            for (GameTweak tweak : tweaks) {
                if (!tweak.equals(GameTweak.FORGE)) continue;
                if (tweaks.length > 1) {
                    System.out.println("[OpenLauncherLib] [WARNING] You selected Forge tweak with other tweaks, Shader tweak and Optifine tweak are ONLY FOR VANILLA, it cans cause bugs and more, the game COULD NOT START !");
                }
                if (!gameVersion.getGameType().equals(GameType.V1_5_2_LOWER)) continue;
                System.out.println("[OpenLauncherLib] [WARNING] You selected Forge tweaking with a version under or equals as 1.5.2, forge is supposed to be installed in the jar (not with a tweaker), the game COULD NOT START !");
            }
        }
        if (tweaks != null && tweaks.length > 0 && gameVersion.getGameType().equals(GameType.V1_5_2_LOWER)) {
            System.out.println("[OpenLauncherLib] [WARNING] You selected tweaking with a version under or equals as 1.5.2, this isn't fully supported, and could cause bugs.");
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public File getGameDir() {
        return this.gameDir;
    }

    public GameVersion getGameVersion() {
        return this.gameVersion;
    }

    public GameTweak[] getGameTweaks() {
        return this.tweaks;
    }

    public boolean hasGameTweak(GameTweak tweak) {
        for (GameTweak gameTweak : this.tweaks) {
            if (!gameTweak.equals(tweak)) continue;
            return true;
        }
        return false;
    }
}

